/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.signature;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatSignatureMessage;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.CK_MECHANISM;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import org.apache.log4j.Logger;

public class GenererSignatureMessage {
    private static Logger log = Logger.getLogger(GenererSignatureMessage.class);

    public static Resultat traitementP11(PKCS11 pKCS11, long l, long l2, long l3, char[] cArray) throws ExceptionTraitement {
        try {
            if (pKCS11 != null) {
                if (cArray != null) {
                    CK_MECHANISM cK_MECHANISM = new CK_MECHANISM();
                    cK_MECHANISM.mechanism = l2;
                    ResultatSignatureMessage resultatSignatureMessage = new ResultatSignatureMessage("G\u00e9n\u00e9ration de la signature d'un message avec " + TraitementsUtil.getNomAlgo(l2) + " (Initialisation (C_SignInit))", "G\u00e9n\u00e9ration de la signature d'un message avec " + TraitementsUtil.getNomAlgo(l2) + " (G\u00e9n\u00e9ration (C_Sign))");
                    if (cArray != null) {
                        byte[] byArray = null;
                        boolean bl = false;
                        try {
                            pKCS11.C_SignInit(l, cK_MECHANISM, l3);
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                            resultatSignatureMessage.setCodeRetour(pKCS11Exception.getErrorCode());
                            bl = true;
                            resultatSignatureMessage.setCodeRetour2(-1L);
                            resultatSignatureMessage.appendOperation2(" NON EXECUTEE!");
                        }
                        try {
                            if (!bl && (byArray = pKCS11.C_Sign(l, new String(cArray).getBytes())) != null) {
                                resultatSignatureMessage.setSignature(TraitementsUtil.getHexadecimal(byArray, 16));
                            }
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                            resultatSignatureMessage.setCodeRetour2(pKCS11Exception.getErrorCode());
                        }
                    }
                    return resultatSignatureMessage;
                }
                log.error((Object)"Le message est nul");
                throw new ExceptionTraitement(28, "Le message est nul");
            }
            log.error((Object)"La librairie est nulle");
            throw new ExceptionTraitement(28, "La librairie est nulle");
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExceptionTraitement) {
                throw (ExceptionTraitement)throwable;
            }
            log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionTraitement(28, "Une erreur inattendue est survenue");
        }
    }
}

